/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.test;

import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.modernui.animation.Animation;
import icyllis.modernui.animation.Applier;
import icyllis.modernui.animation.Interpolator;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.graphics.math.Icon;
import icyllis.modernui.graphics.math.TextAlign;
import icyllis.modernui.view.View;
import icyllis.modernui.widget.LinearLayout;
import icyllis.modernui.widget.Orientation;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class TestLinearLayout
extends LinearLayout {
    private static final Icon ICON = new Icon(new ResourceLocation("modernui", "textures/gui/suk.png"), 0.0f, 0.0f, 1.0f, 1.0f, true);
    private float c = 10.0f;
    private float f = 0.0f;
    private final Animation cAnim;
    private final Animation circleAnimation1;
    private final Animation circleAnimation2;
    private final Animation circleAnimation3;
    private final Animation circleAnimation4;
    private final Animation iconRadiusAni;
    private final Animation arcStartAni;
    private final Animation arcEndAni;
    private final Animation roundRectLenAni;
    private final Animation roundRectAlphaAni;
    private float circleAcc1;
    private float circleAcc2;
    private float circleAcc3;
    private float circleAcc4;
    private float iconRadius = 40.0f;
    private float arcStart = 0.0f;
    private float arcEnd = 0.0f;
    private float roundRectLen = 0.0f;
    private float roundRectAlpha = 0.0f;
    private boolean b;

    public TestLinearLayout() {
        this.setOrientation(Orientation.VERTICAL);
        this.setGravity(17);
        this.setDivider(new Drawable(){

            @Override
            public void draw(@Nonnull Canvas canvas) {
                canvas.moveTo(this);
                canvas.setRGBA(192, 192, 192, 128);
                canvas.drawLine(0.0f, 0.0f, this.getWidth(), 0.0f);
            }

            @Override
            public int getIntrinsicHeight() {
                return 1;
            }
        });
        this.setShowDividers(6);
        this.setDividerPadding(8);
        for (int i = 0; i < 8; ++i) {
            CView v2 = new CView();
            LinearLayout.LayoutParams p = new LinearLayout.LayoutParams(200, 36);
            v2.setEnabled(true);
            v2.setClickable(true);
            this.addView((View)v2, p);
        }
        this.addView((View)new DView(Interpolator.DECELERATE, 0), new LinearLayout.LayoutParams(120, 40));
        this.cAnim = new Animation(200).applyTo(new Applier(20.0f, 0.0f, () -> Float.valueOf(this.c), v -> {
            this.c = v.floatValue();
        }).setInterpolator(Interpolator.DECELERATE));
        this.circleAnimation1 = new Animation(600).applyTo(new Applier((float)Math.PI, (float)(-Math.PI), () -> Float.valueOf(this.circleAcc1), v -> {
            this.circleAcc1 = v.floatValue();
        }).setInterpolator(Interpolator.ACCELERATE_DECELERATE));
        this.circleAnimation2 = new Animation(600).applyTo(new Applier((float)Math.PI, (float)(-Math.PI), () -> Float.valueOf(this.circleAcc2), v -> {
            this.circleAcc2 = v.floatValue();
        }).setInterpolator(Interpolator.ACCELERATE_DECELERATE));
        this.circleAnimation3 = new Animation(600).applyTo(new Applier((float)Math.PI, (float)(-Math.PI), () -> Float.valueOf(this.circleAcc3), v -> {
            this.circleAcc3 = v.floatValue();
        }).setInterpolator(Interpolator.ACCELERATE_DECELERATE));
        this.circleAnimation4 = new Animation(600).applyTo(new Applier((float)Math.PI, (float)(-Math.PI), () -> Float.valueOf(this.circleAcc4), v -> {
            this.circleAcc4 = v.floatValue();
        }).setInterpolator(Interpolator.ACCELERATE_DECELERATE));
        this.iconRadiusAni = new Animation(300).applyTo(new Applier(40.0f, 80.0f, () -> Float.valueOf(this.iconRadius), v -> {
            this.iconRadius = v.floatValue();
        }).setInterpolator(Interpolator.DECELERATE));
        this.arcStartAni = new Animation(800).applyTo(new Applier(-90.0f, 270.0f, () -> Float.valueOf(this.arcStart), v -> {
            this.arcStart = v.floatValue();
        }).setInterpolator(Interpolator.DECELERATE));
        this.arcEndAni = new Animation(800).applyTo(new Applier(-90.0f, 270.0f, () -> Float.valueOf(this.arcEnd), v -> {
            this.arcEnd = v.floatValue();
        }).setInterpolator(Interpolator.ACCELERATE));
        this.roundRectLenAni = new Animation(400).applyTo(new Applier(0.0f, 80.0f, () -> Float.valueOf(this.roundRectLen), v -> {
            this.roundRectLen = v.floatValue();
        }).setInterpolator(Interpolator.OVERSHOOT));
        this.roundRectAlphaAni = new Animation(250).applyTo(new Applier(0.0f, 1.0f, () -> Float.valueOf(this.roundRectAlpha), v -> {
            this.roundRectAlpha = v.floatValue();
        }));
    }

    @Override
    protected void onDraw(@Nonnull Canvas canvas) {
        super.onDraw(canvas);
        canvas.moveTo(this);
        canvas.resetColor();
        canvas.setTextAlign(TextAlign.LEFT);
        canvas.save();
        canvas.scale(3.0f, 3.0f);
        canvas.drawText("A Text", 10.0f, 0.0f);
        canvas.drawText(TextFormatting.BOLD + "A Text", 10.0f, 10.0f);
        canvas.drawText("This is \u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0639\u0631\u0628\u064a\u0629, and she is \u6d77\u87ba", 10.0f, 20.0f);
        canvas.restore();
        Paint paint = Paint.take();
        paint.reset();
        paint.setStyle(Paint.Style.FILL);
        canvas.drawRoundRect(6.0f, 90.0f, 46.0f, 104.0f, 7.0f, paint);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(4.0f);
        canvas.save();
        GL11.glRotatef((float)30.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        canvas.drawRoundRect(6.0f, 110.0f, 86.0f, 124.0f, 6.0f, paint);
        canvas.restore();
        paint.setStyle(Paint.Style.FILL);
        canvas.drawRect(6.0f, 126.0f, 86.0f, 156.0f, paint);
        canvas.drawRoundImage(ICON, 6.0f, 160.0f, 166.0f, 320.0f, this.iconRadius, paint);
        paint.setStyle(Paint.Style.STROKE);
        paint.setFeatherRadius(2.0f);
        paint.setStrokeWidth(10.0f);
        canvas.drawArc(80.0f, 400.0f, 60.0f, this.arcStart, this.arcStart - this.arcEnd, paint);
        paint.setStyle(Paint.Style.FILL);
        paint.setAlpha((int)(this.roundRectAlpha * 255.0f));
        canvas.drawRoundRect(20.0f, 480.0f, 20.0f + this.roundRectLen * 1.6f, 480.0f + this.roundRectLen, 10.0f, paint);
        paint.setAlpha(255);
        canvas.save();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)0.001f);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        paint.setStyle(Paint.Style.FILL);
        paint.setFeatherRadius(0.0f);
        canvas.drawRoundRect(this.c, this.c, 40.0f - this.c, 40.0f - this.c, 3.0f, paint);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-0.001f);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        paint.setFeatherRadius(1.0f);
        paint.setRGBA(80, 210, 240, 128);
        canvas.drawRoundRect(0.0f, 0.0f, 40.0f, 40.0f, 6.0f, paint);
        canvas.restore();
        RenderSystem.depthMask((boolean)false);
        paint.reset();
        canvas.save();
        canvas.translate((float)Math.sin(this.circleAcc1) * 8.0f, (float)Math.cos(this.circleAcc1) * 8.0f);
        canvas.drawCircle(40.0f, 18.0f, 3.0f, paint);
        canvas.restore();
        canvas.save();
        canvas.translate((float)Math.sin(this.circleAcc2) * 8.0f, (float)Math.cos(this.circleAcc2) * 8.0f);
        canvas.drawCircle(40.0f, 18.0f, 2.5f, paint);
        canvas.restore();
        canvas.save();
        canvas.translate((float)Math.sin(this.circleAcc3) * 8.0f, (float)Math.cos(this.circleAcc3) * 8.0f);
        canvas.drawCircle(40.0f, 18.0f, 2.0f, paint);
        canvas.restore();
        canvas.save();
        canvas.translate((float)Math.sin(this.circleAcc4) * 8.0f, (float)Math.cos(this.circleAcc4) * 8.0f);
        canvas.drawCircle(40.0f, 18.0f, 1.5f, paint);
        canvas.restore();
    }

    @Override
    protected boolean onMousePressed(double mouseX, double mouseY, int mouseButton) {
        if (!this.b) {
            this.cAnim.start();
            this.b = true;
        } else {
            this.cAnim.invert();
            this.b = false;
        }
        this.f = 0.95f;
        return true;
    }

    @Override
    protected boolean onMouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.f = 1.0f;
        return true;
    }

    @Override
    protected void tick(int ticks) {
        int a;
        super.tick(ticks);
        if ((ticks & 0xF) == 0) {
            if (!this.b) {
                this.cAnim.start();
                this.iconRadiusAni.start();
                this.b = true;
            } else {
                this.cAnim.invert();
                this.iconRadiusAni.invert();
                this.b = false;
            }
        }
        if ((a = ticks % 20) == 1) {
            this.circleAnimation1.startFull();
            this.arcStartAni.startFull();
            this.arcEndAni.startFull();
            this.roundRectLenAni.startFull();
            this.roundRectAlphaAni.startFull();
        } else if (a == 3) {
            this.circleAnimation2.startFull();
        } else if (a == 5) {
            this.circleAnimation3.startFull();
        } else if (a == 7) {
            this.circleAnimation4.startFull();
        }
    }

    private static class DView
    extends View {
        private final Animation animation;
        private float offsetY;
        private final int offset;

        public DView(Interpolator interpolator, int offset) {
            this.offset = offset;
            this.animation = new Animation(200).applyTo(new Applier(0.0f, 60.0f, () -> Float.valueOf(this.offsetY), v -> {
                this.offsetY = v.floatValue();
            }).setInterpolator(interpolator));
            this.animation.invertFull();
        }

        @Override
        protected void onDraw(@Nonnull Canvas canvas) {
            canvas.setTextAlign(TextAlign.LEFT);
            canvas.drawText("" + TextFormatting.RED + TextFormatting.BLUE + "G", this.offset, this.offsetY + 4.0f);
        }

        @Override
        protected void tick(int ticks) {
            super.tick(ticks);
        }
    }

    private static class CView
    extends View {
        private CView() {
        }

        @Override
        protected void onDraw(@Nonnull Canvas canvas) {
            String str = TextFormatting.UNDERLINE + "Modern" + TextFormatting.AQUA + " UI";
            if (this.isHovered()) {
                Paint paint = Paint.take();
                paint.setRGBA(140, 200, 240, 128);
                canvas.drawRoundRect(0.0f, 1.0f, this.getWidth(), this.getHeight() - 2, 4.0f, paint);
            }
            canvas.resetColor();
            canvas.setTextAlign(TextAlign.CENTER);
            canvas.drawText(str, this.getWidth() >> 1, 4.0f);
        }
    }
}

